local uiPartner = Ui:GetClass("partner");
local tbObject	= Ui.tbLogic.tbObject;
local tbPreViewMgr = Ui.tbLogic.tbPreViewMgr;

uiPartner.BUTTON_CLOSE 		= "BtnClose";
uiPartner.BUTTON_PRESENT 	= "BtnPresent";
uiPartner.BUTTON_ACTIVE 	= "BtnActive";
uiPartner.BUTTON_DISBAND 	= "BtnDisband";
uiPartner.BUTTON_LEVEL_UP 	= "BtnLevelUp";
uiPartner.BUTTON_BINDEQUIP  = "BtnEquipBind";
uiPartner.BUTTON_CONVERT	= "BtnConvert";
uiPartner.LIST_PARTNER 		= "LstPartner";

uiPartner.IMG_CONVERT		= "ImgConvert";
uiPartner.TXT_ACCUMULATE_EXP = "TxtAccumulateExp";
uiPartner.TXT_NEED_EXP 		 = "TxtNeedExp";
uiPartner.TXT_FRIENDSHIP	 = "TxtFriendship";
uiPartner.TXT_TALENT	 	 = "TxtTalent";
uiPartner.TXT_ADD_STR 		 = "TxtAddStr";
uiPartner.TXT_ADD_DEX		 = "TxtAddDex";
uiPartner.TXT_ADD_VIT		 = "TxtAddVit";
uiPartner.TXT_ADD_ENG		 = "TxtAddEng";
uiPartner.TXT_START		 	 = "TxtStart";
uiPartner.TXT_PARTNER_LIST	 = "TxtPartnerList";
uiPartner.SZ_TXT_SKILL_LV	 = "TxtSkillLv";
uiPartner.TXT_FIGHTPOWER	 = "TxtFightPower";
uiPartner.IMG_VKHI	 = "ImgWeapon1";
uiPartner.IMG_Ao	 = "ImgBody1";
uiPartner.IMG_NHAN	 = "ImgRing1";
uiPartner.IMG_TAY	 = "ImgCuff1";
uiPartner.IMG_PHU	 = "ImgAmulet1";
uiPartner.IMG_EFFECT	 = "ImgEffectTBi";
uiPartner.IMG_NECKLACE	 = "ImgNecklace";
uiPartner.IMG_BELT	 = "ImgBelt";
uiPartner.IMG_FOOT	 = "ImgFoot";
uiPartner.IMG_PEDANT	 = "ImgPedant";
uiPartner.IMG_HEAD	 = "ImgHead";
uiPartner.TXT_SKILL_LV 		 = {};
uiPartner.OBJ_PARTNER_PREVIEW 	= "ObjPartnerPreview";
uiPartner.OBJ_SKILL_PREVIEW 	= "ObjSkillPreview";
uiPartner.CONVERT_EFFECT	 = "ImgConvertEffect";
uiPartner.OBJ_SKILL_CONFIGER = { bShowCd = 1, bUse = 0, bLink = 0, bSwitch = 0 };	-- 对应同伴技能
uiPartner.ROWCOUNT = 5;
uiPartner.PARTNER_VALUE = { TEMP_ID = 0, EXP = 1, LEVEL = 2, FRIENDSHIP = 3, TALENT = 4 }; -- 对应代码中的 emPARTNER_VALUE
uiPartner.PARTNER_ATTRIB = {STR = 0, DEX = 1, VIT = 2, ENG = 3}; -- 对应代码中的 emPARTNER_ATTRIB
uiPartner.MAX_SKILL_COUNT = 10;

local PARTNER_EQUIP_OBJ_CONFIGER =
{
	{Item.PARTNEREQUIP_WEAPON,	"ObjWeapon",	"ImgWeapon"},	-- 同伴装备--武器
	{Item.PARTNEREQUIP_BODY,	"ObjBody",		"ImgBody"},		-- 同伴装备--衣服
	{Item.PARTNEREQUIP_RING,	"ObjRing",		"ImgRing"},		-- 同伴装备--戒指
	{Item.PARTNEREQUIP_CUFF,	"ObjCuff",		"ImgCuff"},		-- 同伴装备--护腕
	{Item.PARTNEREQUIP_AMULET,	"ObjAmulet",	"ImgAmulet"},	-- 同伴装备--护身符
}

local tbPartnerEquipCont = { bShowCd = 0, bUse = 0, bLink = 0, nRoom = Item.ROOM_PARTNEREQUIP };	-- 对应同伴装备栏
function uiPartner:OnCreate()
	self.nSelect = 1;
	self.tbSkillIds = {};
	self.tbObjPartnerView = {};
	self.tbObjSkillView = {};
	self.tbObjPartnerView = tbObject:RegisterContainer(self.UIGROUP, self.OBJ_PARTNER_PREVIEW);
	self.tbObjSkillView = tbObject:RegisterContainer(self.UIGROUP, self.OBJ_SKILL_PREVIEW, 5, 2, self.OBJ_SKILL_CONFIGER, "SkillView");
	self.tbObjEquipView = {};
	for i, tbCon in pairs(PARTNER_EQUIP_OBJ_CONFIGER) do
		local nPos = tbCon[1];
		self.tbObjEquipView[nPos] = tbObject:RegisterContainer(
			self.UIGROUP,
			tbCon[2],
			1,
			1,
			{ nOffsetX = nPos, nRoom = Item.ROOM_PARTNEREQUIP },	-- 加上偏移量
			"equiproom"
		);
	end
	
	for i = 1, self.MAX_SKILL_COUNT do
		self.TXT_SKILL_LV[i] = self.SZ_TXT_SKILL_LV..i;
	end
end

function uiPartner:OnKillFocus(szWnd)
	UiManager:CloseWindow(self.UIGROUP);
end

function uiPartner:OnDestroy()
	tbObject:UnregContainer(self.tbObjPartnerView);
	tbObject:UnregContainer(self.tbObjSkillView);
	for _, tbCont in pairs(self.tbObjEquipView) do
		tbObject:UnregContainer(tbCont);
	end
end

function uiPartner:OnClose()
	for _, tbCont in pairs(self.tbObjEquipView) do
		tbCont:ClearRoom();
	end
end

function uiPartner:OnListSel(szWnd, nParam)
	if szWnd == self.LIST_PARTNER then
		local nKey = Lst_GetCurKey(self.UIGROUP, self.LIST_PARTNER);
		self.nSelect = nKey;
		self:UpdatePartner(self.nSelect - 1);
	end
end

function uiPartner:OnObjGridEnter(szWnd, nX, nY)
	if Wnd_Visible(self.UIGROUP, "Main") == 0 then
		return;
	end

	if (szWnd == self.OBJ_SKILL_PREVIEW) then
		local nOffset = 0;
		if nY > 0 then
			nOffset = 5;
		else
			nOffset = 1;
		end
		local uId = nX + nOffset + nY;
		if self.tbSkillIds[uId] then
			Wnd_ShowMouseHoverInfo(self.UIGROUP, szWnd, 
								FightSkill:GetDesc(self.tbSkillIds[uId].nId,
				 				self.tbSkillIds[uId].nLevel));
		end
	end

end

function uiPartner:OnOpen()
	if (Partner.bOpenPartner == 0) then
		return 0;
	end
	
	Wnd_SetVisible(self.UIGROUP, "Main", 1);
	if me.nActivePartner ~= -1 then
		self.nSelect = me.nActivePartner + 1;
	end
	self:Update();
end

function uiPartner:UpdateList()
	Lst_Clear(self.UIGROUP, self.LIST_PARTNER);
	for nIndex = 1, me.nPartnerCount do
		local pPartner = me.GetPartner(nIndex - 1);
		if pPartner then
			Lst_SetCell(self.UIGROUP, self.LIST_PARTNER, nIndex, 1, "   "..pPartner.szName);
			Lst_SetCell(self.UIGROUP, self.LIST_PARTNER, nIndex, 2, pPartner.GetValue(self.PARTNER_VALUE.LEVEL).."");
		end
	end
	
	if me.nActivePartner ~= -1 then
		local pPartner = me.GetPartner(me.nActivePartner);
		if pPartner then
			Lst_SetCell(self.UIGROUP, self.LIST_PARTNER, 
					me.nActivePartner + 1, 1, "<color=orange>★ <color>"..pPartner.szName);
		end
	end
end

function uiPartner:Update()
	if Wnd_Visible(self.UIGROUP, "Main") == 0 then
		return;
	end

	Wnd_SetEnable(self.UIGROUP,self.BUTTON_LEVEL_UP, 0);
	Wnd_SetEnable(self.UIGROUP,self.BUTTON_PRESENT, 0);
	Txt_SetTxt(self.UIGROUP, self.TXT_PARTNER_LIST, "Danh sách đồng hành ("..me.nPartnerCount.."/"..me.nPartnerLimit..")")
	
	self:UpdateList();
	self:UpdateImgPartnerEquip();
	if self.nSelect > me.nPartnerCount and me.nPartnerCount > 0 and me.nPartnerCount <= me.nPartnerLimit then
		if me.nActivePartner ~= -1 then
			self.nSelect = me.nActivePartner + 1;
		else
			self.nSelect = 1;
		end
	end
	Lst_SetCurKey(self.UIGROUP, self.LIST_PARTNER, self.nSelect);
	
	self:UpdatePartner(self.nSelect - 1);
	
	self:UpdatePartnerEquip();
	return 1;
end

function uiPartner:UpdatePartner(nPartnerIndex)
	self:UpdatePartnerInfo(nPartnerIndex);
	self:UpdatePartnerView(nPartnerIndex);
	self:UpdateSkillView(nPartnerIndex);
end

uiPartner.tbListOptPartnerEquip = {
	lifemax_p = "Tỉ lệ sinh lực tối đa: Tăng %s%%",
	deadlystrikedamageenhance_p = "Tấn công khi đánh chí mạng: %s%%",
	manamax_p = "Tỉ lệ nội lực tối đa: Tăng %s%%",
	defencedeadlystrikedamagetrim = "Chịu sát thương chí mạng: %s%%",
	addphysicsdamage_p = "Vật công ngoại: %s%%",
	addphysicsmagic_p = "Vật công nội: %s%%",
	manareplenish_p = "Hiệu suất hồi phục nội lực: %s%%",
	allseriesstateresisttime = "Thời gian bị trạng thái ngũ hành: %s",
	damage_all_resist = "Kháng tất cả: %s",
	lifereplenish_p = "Hiệu suất hồi phục sinh lực: %s%%",
	lifereplenish_v = "Mỗi 5 giây hồi phục sinh lực: %s điểm",
	manareplenish_v = "Mỗi 5 giây hồi phục nội lực: %s điểm",
	staminareplenish_v = "Mỗi 5 giây hồi phục thể lực: %s điểm",
	skilldamageptrim = "Phát huy lực tấn công cơ bản: %s%%",
	ignoredefenseenhance_v = "Bỏ qua né tránh đối thủ: %s",
	stealmana_p = "Chuyển hóa sát thương thành nội lực %s%%",
	seriesenhance = "Cường hóa ngũ hành tương khắc: %s điểm",
	lifemax_v = "Sinh lực tối đa: %s điểm",
	seriesabate = "Nhược hóa ngũ hành tương khắc: %s điểm",
	addphysicsdamage_v = "Vật công ngoại: %s điểm",
	addphysicsmagic_v = "Vật công nội: %s điểm",
	deadlystrikeenhance_r = "Chí mạng: %s",
	skillselfdamagetrim = "Phát huy lực tấn công kỹ năng: %s%%",
	staminamax_v = "Thể lực tối đa: %s điểm",
};

uiPartner.tbInfoPartnerEquip_Define = {
	szColor = {"gold", "gold", "yellow", "yellow"},
	szType = {"Bích Huyết", "Kim Lân", "Đơn Tâm", "Long Đằng", "Long Đằng (Huyền)", "Long Đằng (Địa)", "Long Đằng (Thiên)", "Long Đằng (Thần)"},
	szStars = {
		"<pic=153><pic=153><pic=153><pic=153><pic=153><pic=153><pic=153><pic=152>",
		"<pic=153><pic=153><pic=153><pic=153><pic=153><pic=153><pic=153><pic=153>",
		"<pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=154>",
		"<pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=155>",
		"<pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=155>",
		"<pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=155>",
		"<pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=155>",
		"<pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=155><pic=155>",
	},
	nHonor = {1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000},
};

uiPartner.tbListSuitePartnerEquip = {
	[1] = { -- SuiteID
		[1] = "Cố Nguyên Quyết", -- Name
		[2] = 1983, -- ID
		[3] = {1988, 1989, 1993}, -- PartnerEquipID		
	},
	[2] = { -- SuiteID
		[1] = "Ngự Kinh Quyết", -- Name
		[2] = 1984, -- ID
		[3] = {1990, 1991, 1994}, -- PartnerEquipID		
	},
	[3] = { -- SuiteID
		[1] = "Hỗn Nguyên Quyết", -- Name
		[2] = 1985, -- ID
		[3] = {1995, 1996, 1997}, -- PartnerEquipID		
	},	
};

uiPartner.tbListPartnerEquip = {
	[1988] = {
		[1] = { -- Image
			[1] = "\\image\\item\\partnerequip\\weapon\\partner_lv1_1_s.spr",
			[2] = "\\image\\item\\partnerequip\\weapon\\partner_lv2_1_s.spr",
			[3] = "\\image\\item\\partnerequip\\weapon\\partner_lv3_1_s.spr",
			[4] = "\\image\\item\\partnerequip\\weapon\\partner_lv4_1_s.spr",			
			[5] = "\\image\\item\\partnerequip\\weapon\\partner_lv5_1_s.spr",			
			[6] = "\\image\\item\\partnerequip\\weapon\\partner_lv6_1_s.spr",			
			[7] = "\\image\\item\\partnerequip\\weapon\\partner_lv6_1_s.spr",			
			[8] = "\\image\\item\\partnerequip\\weapon\\partner_lv7_1_s.spr",			
		},
		[2] = uiPartner.IMG_VKHI,
		[3] ={ -- Vu Khi
			lifemax_p={{{1,10},{2,12},{3,15},{4,20},{5,25},{6,30},{7,35},{8,40}}}, -- Ti le SL toi da
			deadlystrikedamageenhance_p ={{{1,15},{2,20},{3,25},{4,30},{5,35},{6,40},{7,45},{8,50}}},	-- Tan cong khi danh chi mang	
		},
		[4] = "Chi Nhẫn", -- Name
		[5] = 1, -- SuiteID
	},
	[1989] = {
		[1] = { -- Image
			[1] = "\\image\\item\\partnerequip\\body\\partner_lv1_2_s.spr",
			[2] = "\\image\\item\\partnerequip\\body\\partner_lv2_2_s.spr",
			[3] = "\\image\\item\\partnerequip\\body\\partner_lv3_2_s.spr",
			[4] = "\\image\\item\\partnerequip\\body\\partner_lv4_2_s.spr",			
			[5] = "\\image\\item\\partnerequip\\body\\partner_lv5_2_s.spr",			
			[6] = "\\image\\item\\partnerequip\\body\\partner_lv6_2_s.spr",			
			[7] = "\\image\\item\\partnerequip\\body\\partner_lv6_2_s.spr",			
			[8] = "\\image\\item\\partnerequip\\body\\partner_lv7_2_s.spr",			
		},
		[2] = uiPartner.IMG_Ao,	
		[3] ={ -- Y Phuc
			manamax_p={{{1,10},{2,12},{3,15},{4,20},{5,25},{6,30},{7,35},{8,40}}}, -- Ti le NL toi da
			defencedeadlystrikedamagetrim ={{{1,15},{2,20},{3,25},{4,30},{5,35},{6,40},{7,45},{8,50}}}, -- Chiu sat thuong chi mang
		},
		[4] = "Chiến Y",
		[5] = 1, -- SuiteID
	},
	[1990] = {
		[1] = { -- Image
			[1] = "\\image\\item\\partnerequip\\ring\\partner_ring_01_s.spr",
			[2] = "\\image\\item\\partnerequip\\ring\\partner_ring_02_s.spr",
			[3] = "\\image\\item\\partnerequip\\ring\\partner_ring_03_s.spr",
			[4] = "\\image\\item\\partnerequip\\ring\\partner_ring_04_s.spr",		
			[5] = "\\image\\item\\partnerequip\\ring\\partner_ring_05_s.spr",		
			[6] = "\\image\\item\\partnerequip\\ring\\partner_ring_06_s.spr",		
			[7] = "\\image\\item\\partnerequip\\ring\\partner_ring_06_s.spr",		
			[8] = "\\image\\item\\partnerequip\\ring\\partner_ring_07_s.spr",		
		},
		[2] = uiPartner.IMG_NHAN,
		[3] ={ -- Nhan
			addphysicsdamage_p={{{1,100},{2,150},{3,200},{4,250},{5,350},{6,450},{7,550},{8,650}}}, -- Vat cong ngoai
			addphysicsmagic_p ={{{1,100},{2,150},{3,200},{4,250},{5,350},{6,450},{7,550},{8,650}}},	-- Vat cong noi
			manareplenish_p ={{{1,11},{2,13},{3,16},{4,19},{5,22},{6,25},{7,28},{8,31}}},	-- Hieu suat phuc hoi noi luc
			allseriesstateresisttime ={{{1,50},{2,75},{3,100},{4,125},{5,150},{6,175},{7,200},{8,225}}},	-- Thoi gian bi trang thai ngu hanh
		},
		[4] = "Giới Chỉ",
		[5] = 2, -- SuiteID
	},
	[1991] = {
		[1] = { -- Image
			[1] = "\\image\\item\\partnerequip\\cuff\\partner_cuff_01_s.spr",
			[2] = "\\image\\item\\partnerequip\\cuff\\partner_cuff_02_s.spr",
			[3] = "\\image\\item\\partnerequip\\cuff\\partner_cuff_03_s.spr",
			[4] = "\\image\\item\\partnerequip\\cuff\\partner_cuff_04_s.spr",		
			[5] = "\\image\\item\\partnerequip\\cuff\\partner_cuff_05_s.spr",		
			[6] = "\\image\\item\\partnerequip\\cuff\\partner_cuff_06_s.spr",		
			[7] = "\\image\\item\\partnerequip\\cuff\\partner_cuff_06_s.spr",		
			[8] = "\\image\\item\\partnerequip\\cuff\\partner_cuff_07_s.spr",		
		},
		[2] = uiPartner.IMG_TAY,	
		[3] ={ -- Tay
			damage_all_resist={{{1,75},{2,90},{3,105},{4,115},{5,125},{6,135},{7,145},{8,155}}}, -- Khang tat ca
			lifereplenish_p ={{{1,11},{2,13},{3,16},{4,19},{5,22},{6,25},{7,28},{8,31}}},	-- Hieu suat phuc hoi sinh luc
		},	
		[4] = "Hộ Uyển",
		[5] = 2, -- SuiteID
	},
	[1992] = {
		[1] = { -- Image
			[1] = "\\image\\item\\partnerequip\\amulet\\partner_lv1_3_s.spr",
			[2] = "\\image\\item\\partnerequip\\amulet\\partner_lv2_3_s.spr",
			[3] = "\\image\\item\\partnerequip\\amulet\\partner_lv3_3_s.spr",
			[4] = "\\image\\item\\partnerequip\\amulet\\partner_lv4_3_s.spr",		
			[5] = "\\image\\item\\partnerequip\\amulet\\partner_lv5_3_s.spr",		
			[6] = "\\image\\item\\partnerequip\\amulet\\partner_lv6_3_s.spr",		
			[7] = "\\image\\item\\partnerequip\\amulet\\partner_lv6_3_s.spr",		
			[8] = "\\image\\item\\partnerequip\\amulet\\partner_lv7_3_s.spr",		
		},
		[2] = uiPartner.IMG_PHU,	
		[3] ={ -- Ho than phu
			lifereplenish_v={{{1,30},{2,40},{3,50},{4,60},{5,70},{6,80},{7,90},{8,100}}}, -- Moi 5 giay hoi phuc sinh luc
			manareplenish_v ={{{1,30},{2,40},{3,50},{4,60},{5,70},{6,80},{7,90},{8,100}}},	-- Moi 5 giay hoi phuc noi luc
			staminareplenish_v ={{{1,30},{2,40},{3,50},{4,60},{5,70},{6,80},{7,90},{8,100}}},	-- Moi 5 giay hoi phuc the luc
			damage_all_resist ={{{1,15},{2,20},{3,25},{4,30},{5,35},{6,40},{7,45},{8,50}}},	-- Khang tat ca
		},	
		[4] = "Hộ Phù",
	},
	[1993] = {
		[1] = { -- Image
			[1] = "\\image\\item\\partnerequip\\necklace\\partner_necklace_01_s.spr",
			[2] = "\\image\\item\\partnerequip\\necklace\\partner_necklace_02_s.spr",
			[3] = "\\image\\item\\partnerequip\\necklace\\partner_necklace_03_s.spr",
			[4] = "\\image\\item\\partnerequip\\necklace\\partner_necklace_04_s.spr",		
			[5] = "\\image\\item\\partnerequip\\necklace\\partner_necklace_05_s.spr",		
			[6] = "\\image\\item\\partnerequip\\necklace\\partner_necklace_06_s.spr",		
			[7] = "\\image\\item\\partnerequip\\necklace\\partner_necklace_06_s.spr",		
			[8] = "\\image\\item\\partnerequip\\necklace\\partner_necklace_07_s.spr",		
		},
		[2] = uiPartner.IMG_NECKLACE,	
		[3] ={ -- Hang lien
			skilldamageptrim ={{{1,10},{2,17},{3,25},{4,32},{5,39},{6,46},{7,53},{8,60}}}, -- Luc tan cong co ban
			ignoredefenseenhance_v ={{{1,155},{2,415},{3,605},{4,798},{5,991},{6,1184},{7,1377},{8,1570}}}, -- Bo qua ne tranh doi thu
			stealmana_p ={{{1,1},{2,3},{3,5},{4,7},{5,9},{6,11},{7,13},{8,15}}}, -- Chuyen hoa st thanh noi luc
			seriesenhance ={{{1,55},{2,135},{3,205},{4,265},{5,325},{6,385},{7,445},{8,505}}}, -- Cuong hoa ngu hanh tuong khac
		},	
		[4] = "Hạng Liên",
		[5] = 1, -- SuiteID
	},
	[1994] = {
		[1] = { -- Image
			[1] = "\\image\\item\\partnerequip\\belt\\partner_belt_01_s.spr",
			[2] = "\\image\\item\\partnerequip\\belt\\partner_belt_02_s.spr",
			[3] = "\\image\\item\\partnerequip\\belt\\partner_belt_03_s.spr",
			[4] = "\\image\\item\\partnerequip\\belt\\partner_belt_04_s.spr",		
			[5] = "\\image\\item\\partnerequip\\belt\\partner_belt_05_s.spr",		
			[6] = "\\image\\item\\partnerequip\\belt\\partner_belt_06_s.spr",		
			[7] = "\\image\\item\\partnerequip\\belt\\partner_belt_06_s.spr",		
			[8] = "\\image\\item\\partnerequip\\belt\\partner_belt_07_s.spr",		
		},
		[2] = uiPartner.IMG_BELT,	
		[3] ={ -- Lung
			damage_all_resist={{{1,70},{2,105},{3,140},{4,175},{5,210},{6,245},{7,280},{8,315}}}, -- Khang tat ca
			lifemax_v ={{{1,500},{2,1000},{3,1500},{4,2000},{5,2500},{6,3000},{7,3500},{8,4000}}}, -- Sinh luc toi da diem
			seriesabate ={{{1,55},{2,135},{3,205},{4,265},{5,325},{6,385},{7,445},{8,505}}}, -- Nhuoc hoa ngu hanh tuoc khac
		},
		[4] = "Thúc Yêu",
		[5] = 2, -- SuiteID
	},
	[1995] = {
		[1] = { -- Image
			[1] = "\\image\\item\\partnerequip\\foot\\partner_foot_lv1_s.spr",
			[2] = "\\image\\item\\partnerequip\\foot\\partner_foot_lv2_s.spr",
			[3] = "\\image\\item\\partnerequip\\foot\\partner_foot_lv3_s.spr",
			[4] = "\\image\\item\\partnerequip\\foot\\partner_foot_lv4_s.spr",		
			[5] = "\\image\\item\\partnerequip\\foot\\partner_foot_lv5_s.spr",		
			[6] = "\\image\\item\\partnerequip\\foot\\partner_foot_lv6_s.spr",		
			[7] = "\\image\\item\\partnerequip\\foot\\partner_foot_lv6_s.spr",		
			[8] = "\\image\\item\\partnerequip\\foot\\partner_foot_lv7_s.spr",		
		},
		[2] = uiPartner.IMG_FOOT,	
		[3] ={ -- Giay
			addphysicsdamage_v={{{1,2560},{2,4100},{3,5120},{4,6140},{5,8160},{6,10180},{7,12200},{8,14220}}}, -- Vat cong ngoai - diem
			addphysicsmagic_v={{{1,2560},{2,4100},{3,5120},{4,6140},{5,8160},{6,10180},{7,12200},{8,14220}}}, -- Vat cong noi - diem
			deadlystrikeenhance_r ={{{1,10},{2,15},{3,20},{4,30},{5,40},{6,50},{7,60},{8,70}}},	-- Tang ti le chi mang
		},	
		[4] = "Chiến Ngoa",
		[5] = 3, -- SuiteID
	},
	[1996] = {
		[1] = { -- Image
			[1] = "\\image\\item\\partnerequip\\pendant\\partner_pendant_lv1_s.spr",
			[2] = "\\image\\item\\partnerequip\\pendant\\partner_pendant_lv2_s.spr",
			[3] = "\\image\\item\\partnerequip\\pendant\\partner_pendant_lv3_s.spr",
			[4] = "\\image\\item\\partnerequip\\pendant\\partner_pendant_lv4_s.spr",		
			[5] = "\\image\\item\\partnerequip\\pendant\\partner_pendant_lv5_s.spr",		
			[6] = "\\image\\item\\partnerequip\\pendant\\partner_pendant_lv6_s.spr",		
			[7] = "\\image\\item\\partnerequip\\pendant\\partner_pendant_lv6_s.spr",		
			[8] = "\\image\\item\\partnerequip\\pendant\\partner_pendant_lv7_s.spr",		
		},
		[2] = uiPartner.IMG_PEDANT,	
		[3] ={ -- Boi
			skilldamageptrim ={{{1,5},{2,10},{3,15},{4,20},{5,35},{6,50},{7,65},{8,80}}}, -- Luc tan cong co ban
			skillselfdamagetrim={{{1,5},{2,10},{3,15},{4,20},{5,35},{6,50},{7,65},{8,80}}}, -- Luc tan cong ky nang
			staminamax_v={{{1,500},{2,750},{3,1000},{4,1250},{5,1500},{6,1750},{7,2000},{8,2250}}}, -- Tang the luc toi da - diem
		},	
		[4] = "Ngọc Bội",
		[5] = 3, -- SuiteID
	},
	[1997] = {
		[1] = { -- Image
			[1] = "\\image\\item\\partnerequip\\head\\partner_head_lv1_s.spr",
			[2] = "\\image\\item\\partnerequip\\head\\partner_head_lv2_s.spr",
			[3] = "\\image\\item\\partnerequip\\head\\partner_head_lv3_s.spr",
			[4] = "\\image\\item\\partnerequip\\head\\partner_head_lv4_s.spr",		
			[5] = "\\image\\item\\partnerequip\\head\\partner_head_lv5_s.spr",		
			[6] = "\\image\\item\\partnerequip\\head\\partner_head_lv6_s.spr",		
			[7] = "\\image\\item\\partnerequip\\head\\partner_head_lv6_s.spr",		
			[8] = "\\image\\item\\partnerequip\\head\\partner_head_lv7_s.spr",		
		},
		[2] = uiPartner.IMG_HEAD,	
		[3] ={ -- Non
			damage_all_resist={{{1,50},{2,100},{3,150},{4,200},{5,250},{6,300},{7,350},{8,400}}}, -- Khang tat ca
			seriesabate ={{{1,50},{2,135},{3,205},{4,265},{5,325},{6,385},{7,445},{8,505}}}, -- Nhuoc hoa ngu hanh tuoc khac
			defencedeadlystrikedamagetrim ={{{1,10},{2,15},{3,20},{4,30},{5,40},{6,50},{7,60},{8,70}}}, -- Chiu sat thuong chi mang
		},	
		[4] = "Chi Quán",
		[5] = 3, -- SuiteID
	}		
};
function uiPartner:UpdateImgPartnerEquip()
	
	for nIdPartnerEquip, tbData in pairs(self.tbListPartnerEquip) do
		local nLvPartnerEquip = me.GetSkillLevel(nIdPartnerEquip)
		if self.tbListPartnerEquip[nIdPartnerEquip][1][nLvPartnerEquip] then
			Img_SetImage(self.UIGROUP,
			self.tbListPartnerEquip[nIdPartnerEquip][2],
			1,
			self.tbListPartnerEquip[nIdPartnerEquip][1][nLvPartnerEquip]);
		end
	end
end
function uiPartner:UpdatePartnerView(nPartnerIndex)
	if not self.tbObjPartnerView.szObjGrid then
		print("No tbObjPartnerView");
		return;
	end
	self.tbObjPartnerView:ClearObj();
	if nPartnerIndex < 0 or  nPartnerIndex >= me.nPartnerCount then
		return;
	end
	local pPartner = me.GetPartner(nPartnerIndex);
	if not pPartner then
		return;
	end
	
	local tbPart = tbPreViewMgr:GetSelfPart();
	local nNpcId = Partner.tbPartIdToNpcId[pPartner.GetValue(self.PARTNER_VALUE.TEMP_ID)];
	if not nNpcId then
		return;
	end
	local tbObj = {};
	tbObj.nType = Ui.OBJ_NPCRES;
	tbObj.nTemplateId = nNpcId;
	tbObj.nAction = Npc.ACT_STAND1;
	tbObj.tbPart = tbPart;
	tbObj.nDir = 0;
	tbObj.bRideHorse = 0;
	self.tbObjPartnerView:SetObj(tbObj);
end

function uiPartner:UpdateSkillView(nPartnerIndex)
	self.tbSkillIds = {};
	if not self.tbObjSkillView.szObjGrid then
		print("No tbObjSkillView")
		return;
	end
	self.tbObjSkillView:ClearObj();
	self:ClearSkillLevel();
	if nPartnerIndex < 0 or  nPartnerIndex >= me.nPartnerCount then
		return;
	end
	local pPartner = me.GetPartner(nPartnerIndex);
	if not pPartner then
		return;
	end

	for nIndex = 1, pPartner.nSkillCount do
		table.insert(self.tbSkillIds, pPartner.GetSkill(nIndex - 1));
	end

		   	
	local nRow = 0;
	local nLine = 0;
	for nIndex, tbPartnerSkill in ipairs(self.tbSkillIds) do
		nRow = nIndex - 1;
		if nIndex > self.ROWCOUNT and self.ROWCOUNT > 0 then
			nRow = nRow - self.ROWCOUNT;
			nLine = math.floor(nRow / self.ROWCOUNT) + 1;
		end
		local tbSkill = {};
		tbSkill.nType = Ui.OBJ_FIGHTSKILL;
		tbSkill.nSkillId = tbPartnerSkill.nId;
		self.tbObjSkillView:SetObj(tbSkill, nRow, nLine);
		ObjBox_Clear(self.UIGROUP, Ui.OBJ_FIGHTSKILL);
		ObjBox_HoldObject(self.UIGROUP, self.OBJ_SKILL_PREVIEW, Ui.CGOG_SKILL_SHORTCUT, tbPartnerSkill.nId);	
		Txt_SetTxt(self.UIGROUP, self.TXT_SKILL_LV[nIndex], tbPartnerSkill.nLevel);	
	end
end

function uiPartner:UpdatePartnerEquip()
	for i, tbCont in pairs(self.tbObjEquipView) do
		tbCont:UpdateRoom();
	end
end

function uiPartner:UpdateEquipDur()
	for _, tbCont in pairs(self.tbObjEquipView) do
		if tbCont then
			local pItem = me.GetItem(tbCont.nRoom, tbCont.nOffsetX, tbCont.nOffsetY);
			if pItem then
				if tbCont.nOffsetX >= Item.PARTNEREQUIP_WEAPON and tbCont.nOffsetY <= Item.PARTNEREQUIP_AMULET then
					ObjGrid_ShowSubScript(tbCont.szUiGroup, tbCont.szObjGrid, 1, 0, 0);
					local nPerDur = math.ceil((pItem.nCurDur / pItem.nMaxDur) * 100)
					if nPerDur > 0 and nPerDur <= 10 then
						ObjGrid_ChangeSubScriptColor(tbCont.szUiGroup, tbCont.szObjGrid, "Red");
					elseif nPerDur > 10 and nPerDur <= 60 then
						ObjGrid_ChangeSubScriptColor(tbCont.szUiGroup, tbCont.szObjGrid, "yellow");
					elseif nPerDur > 60 then
						ObjGrid_ChangeSubScriptColor(tbCont.szUiGroup, tbCont.szObjGrid, "green");
					end;
				
					local szDur = tostring(nPerDur).."%";
					ObjGrid_ChangeSubScript(tbCont.szUiGroup, tbCont.szObjGrid, szDur, 0, 0);
				end
			end
		end
	end
end

function uiPartner:ClearSkillLevel()
	for i = 1, self.MAX_SKILL_COUNT do
		Txt_SetTxt(self.UIGROUP, self.TXT_SKILL_LV[i], "");	
	end
end

function uiPartner:UpdatePartnerInfo(nPartnerIndex)
	local szAccumulateExp =  "Kinh nghiệm hiện tại: ";
	local szNeedExp = "Kinh nghiệm cần: ";
	local szFriendship = "Thân mật: ";
	local szTalent = "Lĩnh ngộ: ";
	local szAddStr = "Sức mạnh tăng: ";
	local szAddDex = "Thân pháp tăng: ";
	local szTxtAddVit = "Ngoại công tăng: ";
	local szTxtAddEng = "Nội công tăng: ";
	local szFightPower = "Tăng sức chiến đấu: ";
	local szStart = "";

	if nPartnerIndex >= 0 and nPartnerIndex < me.nPartnerCount then
		local pPartner = me.GetPartner(nPartnerIndex);
		if pPartner then
			szStart = self:SetStart(nPartnerIndex);
			szAccumulateExp = szAccumulateExp..pPartner.GetValue(self.PARTNER_VALUE.EXP);
			szNeedExp = szNeedExp..Partner:GetNeedLevel(pPartner.GetValue(self.PARTNER_VALUE.LEVEL));
			local szTemp = string.format("%0.2f", pPartner.GetValue(self.PARTNER_VALUE.FRIENDSHIP) / 100);
			szFriendship = szFriendship..szTemp;
			local nTalent = pPartner.GetValue(self.PARTNER_VALUE.TALENT) % 1000
			szTalent = szTalent..nTalent;
			szAddStr = szAddStr..pPartner.GetAttrib(self.PARTNER_ATTRIB.STR);
			szAddDex = szAddDex..pPartner.GetAttrib(self.PARTNER_ATTRIB.DEX);
			szTxtAddVit = szTxtAddVit..pPartner.GetAttrib(self.PARTNER_ATTRIB.VIT);
			szTxtAddEng = szTxtAddEng..pPartner.GetAttrib(self.PARTNER_ATTRIB.ENG);
		end
	end
	local nKey = Lst_GetCurKey(self.UIGROUP, self.LIST_PARTNER);
	if me.nActivePartner ~= nKey - 1 or me.nActivePartner == -1 then
		Btn_SetTxt(self.UIGROUP, self.BUTTON_ACTIVE, "Giúp đỡ");
		Wnd_SetEnable(self.UIGROUP,self.BUTTON_LEVEL_UP, 0);
		Wnd_SetEnable(self.UIGROUP,self.BUTTON_PRESENT, 0);
	else
		Btn_SetTxt(self.UIGROUP, self.BUTTON_ACTIVE, "Đứng nhìn");
		Wnd_SetEnable(self.UIGROUP,self.BUTTON_LEVEL_UP, 1);
		Wnd_SetEnable(self.UIGROUP,self.BUTTON_PRESENT, 1);
	end
	Txt_SetTxt(self.UIGROUP, self.TXT_START, szStart);
	Txt_SetTxt(self.UIGROUP, self.TXT_ACCUMULATE_EXP, szAccumulateExp);
	Txt_SetTxt(self.UIGROUP, self.TXT_NEED_EXP, szNeedExp);
	Txt_SetTxt(self.UIGROUP, self.TXT_FRIENDSHIP, szFriendship);
	Txt_SetTxt(self.UIGROUP, self.TXT_TALENT, szTalent);
	Txt_SetTxt(self.UIGROUP, self.TXT_ADD_STR, szAddStr);
	Txt_SetTxt(self.UIGROUP, self.TXT_ADD_DEX, szAddDex);
	Txt_SetTxt(self.UIGROUP, self.TXT_ADD_VIT, szTxtAddVit);
	Txt_SetTxt(self.UIGROUP, self.TXT_ADD_ENG, szTxtAddEng);
end

function uiPartner:SetStart(nPartnerIndex)
	local szTip = "\n  ";
	if not nPartnerIndex then
		return szTip;
	end
	local tbSetting = Partner.tbStarLevel;
	local pPartner = me.GetPartner(nPartnerIndex);
	if not pPartner then
		return szTip;
	end
	local nStartCount = Partner:GetSelfStartCount(pPartner);
	local szFillStar = "";
	local szEmptyStar = "";
	if tbSetting and tbSetting[nStartCount] then
		szFillStar = string.format("<pic=%s>", tbSetting[nStartCount].nFillStar - 1);
		szEmptyStar = string.format("<pic=%s>", tbSetting[nStartCount].nEmptyStar - 1);
	else
		szFillStar = "★";
		szEmptyStar = "☆";
	end

	for i = 1, math.floor(nStartCount / 2) do
		szTip = szTip..szFillStar;
		if i % 3 == 0 then
			szTip = szTip.." ";
		end
	end
	if (nStartCount % 2 ~= 0) then
		szTip = szTip..szEmptyStar;
	end
	return	szTip;
end
function uiPartner:OnButtonClick(szWnd, nParam)
	if (szWnd == self.BUTTON_CLOSE) then
		UiManager:CloseWindow(self.UIGROUP);
	elseif (szWnd == self.BUTTON_PRESENT) then
		if me.nActivePartner >= 0 and me.nActivePartner <= me.nPartnerLimit then
			me.CallServerScript({ "PartnerCmd", "SendGift", me.nActivePartner});
		end
	elseif (szWnd == self.BUTTON_LEVEL_UP) then
		if me.nActivePartner >= 0 and me.nActivePartner <= me.nPartnerLimit then
			me.CallServerScript({ "PartnerCmd", "UpgradeLevel", me.nActivePartner});
		end
	elseif (szWnd == self.BUTTON_ACTIVE) then
		local nKey = Lst_GetCurKey(self.UIGROUP, self.LIST_PARTNER);
		if nKey > 0 and nKey <= me.nPartnerLimit then
			me.CallServerScript({ "PartnerCmd", "CallPartner", nKey - 1});
		else
			me.Msg("Hãy chọn đồng hành cần thao tác");
		end
	elseif (szWnd == self.BUTTON_DISBAND) then
		local nKey = Lst_GetCurKey(self.UIGROUP, self.LIST_PARTNER);
		if nKey > 0 and nKey <= me.nPartnerLimit then
			me.CallServerScript({ "PartnerCmd", "DissolvePartner", nKey - 1});
		else
			me.Msg("Hãy chọn đồng hành cần giải tán");
		end
	elseif (szWnd == self.BUTTON_BINDEQUIP) then
		me.CallServerScript({"PartnerCmd", "BindEquip", me.nId});
	elseif (szWnd == self.BUTTON_CONVERT) then
		local nKey = Lst_GetCurKey(self.UIGROUP, self.LIST_PARTNER);
		if nKey > 0 and nKey <= me.nPartnerLimit then
			me.CallServerScript({"PartnerCmd", "Convert", nKey - 1});
		else
			me.Msg("Hãy chọn đồng hành mà bạn muốn chuyển hóa");
		end
	end
end

-- function uiPartner:Contains(t, e)
	-- for i = 1, #t do
		-- if t[i] == e then 
		-- return true
		-- end
	-- end
	-- return false
-- end

function uiPartner:GetDescPartnerEquip(nIdPartnerEquip)
	if nIdPartnerEquip then
		local szNamePartnerEquip = self.tbListPartnerEquip[nIdPartnerEquip][4];
		local nLevelPartnerEquip = me.GetSkillLevel(nIdPartnerEquip);
		local tbOptPartnerEquip = self.tbListPartnerEquip[nIdPartnerEquip][3];
		
		local szTip = "<color=yellow>Đồng Hành ".. szNamePartnerEquip .." - ".. self.tbInfoPartnerEquip_Define.szType[nLevelPartnerEquip] .."<color>\n"..
		"\n   ".. self.tbInfoPartnerEquip_Define.szStars[nLevelPartnerEquip] .."\n"..	
		"<color=cyan>Tài phú:<color> <color=green>".. self.tbInfoPartnerEquip_Define.nHonor[nLevelPartnerEquip] .."<color>\n\n"..	
		"".. szNamePartnerEquip .." Đồng Hành     Đã khóa\n"..
		"Không đổi được Không tách được Không thể luyện hóa\n\n"..
		"Trang bị yêu cầu: 100\n"..
		"Cấp trang bị: "..nLevelPartnerEquip.." Ngũ hành: Vô\n\n"			
		
		local szListOpt = "";
		for szOptPartnerEquip, tbRowData in pairs(tbOptPartnerEquip) do
			if tbOptPartnerEquip[szOptPartnerEquip] then
				local tbOptDetailPartnerEquip = tbOptPartnerEquip[szOptPartnerEquip];
				for nIndDeailOpt, tbDetailOpt in pairs(tbOptDetailPartnerEquip) do
					local tbListOptByLvelPartnerEquip = tbOptDetailPartnerEquip[nIndDeailOpt];
					if tbListOptByLvelPartnerEquip[nLevelPartnerEquip] then
						local nOptByLevelPartnerEquip = tbListOptByLvelPartnerEquip[nLevelPartnerEquip][2];
						local szOptDetail = string.format("<color=green>".. self.tbListOptPartnerEquip[szOptPartnerEquip], nOptByLevelPartnerEquip);					
						szListOpt = szListOpt..""..szOptDetail.."\n";
					end
				end
			end
		end
		
		local szDescSuite = "";
		local nProgressSuitePartnerEquip = 0;
		local szNameSuiteParnterEquip = "";
		
		if self.tbListPartnerEquip[nIdPartnerEquip][5] then
			local nSuiteID = self.tbListPartnerEquip[nIdPartnerEquip][5];
			szNameSuiteParnterEquip = self.tbListSuitePartnerEquip[nSuiteID][1];
			
			for i = 1, #self.tbListSuitePartnerEquip[nSuiteID][3] do
				local tbListPartnerEquipInSuite = self.tbListSuitePartnerEquip[nSuiteID][3];
				local nIdPartnerEquipInSuite = tbListPartnerEquipInSuite[i];
				local nLvPartnerEquipInSuite = me.GetSkillLevel(nIdPartnerEquipInSuite);
				local szNamePartnerEquipInSuite = self.tbListPartnerEquip[nIdPartnerEquipInSuite][4];
				if nLvPartnerEquipInSuite > 0 then
					nProgressSuitePartnerEquip = nProgressSuitePartnerEquip + 1;
					szDescSuite = szDescSuite.."<color=yellow>Đồng Hành ".. szNamePartnerEquipInSuite .."\n";
				else
					szDescSuite = szDescSuite.."<color=gray>Đồng Hành ".. szNamePartnerEquipInSuite .."\n";
				end
			end
		end
			
		szTip = szTip..""..szListOpt;
		
		if szDescSuite ~= "" then
			local szInfoProgressSuite = "<color=blue>Bộ "..szNameSuiteParnterEquip.." ("..nProgressSuitePartnerEquip.."/3)<color>"
			szInfoProgressSuite = szInfoProgressSuite.."\n"..szDescSuite;
			
			local szInfoSkillActiveSuite = "<color=gray>(3 cái) Kích hoạt kỹ năng "..szNameSuiteParnterEquip.."<color>";
			if nProgressSuitePartnerEquip >= 3 then
				szInfoSkillActiveSuite = "<color=green>(3 cái) Kích hoạt kỹ năng "..szNameSuiteParnterEquip.."<color>";
			end
			
			szTip = szTip.."\n"..szInfoProgressSuite;
			szTip = szTip..""..szInfoSkillActiveSuite;
		end
		
		szTip = szTip.."\n\n<color=yellow><Trang bị hiện tại><color>";		
		
		return szTip;
	else
		return "";
	end
end
function uiPartner:OnMouseEnter(szWnd)
	local nLevelLien = me.GetSkillLevel(1993)
	local nLevelLung = me.GetSkillLevel(1994)
	local nLevelGiay = me.GetSkillLevel(1995)
	local nLevelBoi = me.GetSkillLevel(1996)
	local nLevelNon = me.GetSkillLevel(1997)
	local nLevelVKhi = me.GetSkillLevel(1988)
	local nLevelAo = me.GetSkillLevel(1989)
	local nLevelNhan = me.GetSkillLevel(1990)
	local tbTayDHanh = me.GetSkillLevel(1991)
	local tbPhuDHanh = me.GetSkillLevel(1992)
	local szTip = "";
	
	if (szWnd == self.IMG_NECKLACE) then
		szTip = self:GetDescPartnerEquip(1993)
	elseif (szWnd == self.IMG_BELT) then
		szTip = self:GetDescPartnerEquip(1994)
	elseif (szWnd == self.IMG_FOOT) then
		szTip = self:GetDescPartnerEquip(1995)
	elseif (szWnd == self.IMG_PEDANT) then
		szTip = self:GetDescPartnerEquip(1996)
	elseif (szWnd == self.IMG_HEAD) then
		szTip = self:GetDescPartnerEquip(1997)
	elseif (szWnd == self.IMG_VKHI) then
		szTip = self:GetDescPartnerEquip(1988)
	elseif (szWnd == self.IMG_Ao) then
		szTip = self:GetDescPartnerEquip(1989)
	elseif (szWnd == self.IMG_NHAN) then
		szTip = self:GetDescPartnerEquip(1990)
	elseif (szWnd == self.IMG_TAY) then
		szTip = self:GetDescPartnerEquip(1991)
	elseif (szWnd == self.IMG_PHU) then
		szTip = self:GetDescPartnerEquip(1992)
	end
	
	if (szTip ~= "") then
		Wnd_ShowMouseHoverInfo(self.UIGROUP, szWnd, "", szTip);
	end	
end
function uiPartner:RegisterEvent()
	local tbRegEvent = 
	{
		{ UiNotify.emCOREEVENT_SYNC_PARTNER,	self.Update },
		{ UiNotify.emCOREEVENT_SYNC_ITEM,		self.UpdatePartnerEquip },
	};
	tbRegEvent = Lib:MergeTable(tbRegEvent, self.tbObjSkillView:RegisterEvent());
	for _, tbCont in pairs(self.tbObjEquipView) do
		tbRegEvent = Lib:MergeTable(tbRegEvent, tbCont:RegisterEvent());
	end
	return tbRegEvent;
end

function uiPartner:RegisterMessage()
	local tbRegMsg = self.tbObjSkillView:RegisterMessage();
	for _, tbCont in pairs(self.tbObjEquipView) do
		tbRegMsg = Lib:MergeTable(tbRegMsg, tbCont:RegisterMessage());
	end
	return tbRegMsg;
end

function uiPartner:SetEquipPosHighLight(tbObj)
	local nRet = 1;
	if not tbObj or tbObj.nType ~= Ui.OBJ_OWNITEM then
		self:ReleaseEquipPosHighLight();
		return;
	end
	local pItem = me.GetItem(tbObj.nRoom, tbObj.nX, tbObj.nY);
	if (not pItem) or (not pItem.nEquipPos) or (pItem.nEquipPos < Item.EQUIPPOS_NUM)then
		self:ReleaseEquipPosHighLight();
		return;
	end
	-- me.Msg("tbObj.nRoom partner: " .. tostring(tbObj.nRoom));
	-- me.Msg("tbObj.nX partner: " .. tostring(tbObj.nX));
	-- me.Msg("tbObj.nY partner: " .. tostring(tbObj.nY));
	-- me.Msg("pItem.nEquipPos partner: " .. tostring(pItem.nEquipPos));
	local nPosition = pItem.nEquipPos - Item.EQUIPPOS_NUM;
	local tbEquipWnd = self:GetEquipWndTableItem(nPosition);
	if tbEquipWnd then
		self.m_szHighLightEquipPos = tbEquipWnd[3];
		Img_SetFrame(self.UIGROUP, self.m_szHighLightEquipPos, 0);
	end	
end

function uiPartner:ReleaseEquipPosHighLight()
	if self.m_szHighLightEquipPos == nil then
		return;
	end
	Img_SetFrame(self.UIGROUP, self.m_szHighLightEquipPos, 1);
	self.m_szHighLightEquipPos = nil;
end

function uiPartner:GetEquipWndTableItem(nPosition)
	for _, tbEquipItem in ipairs(PARTNER_EQUIP_OBJ_CONFIGER) do
		if tbEquipItem[1] == nPosition then
			return tbEquipItem;
		end
	end
end
