

local tbMenPaiNpc	= {};
Npc.tbMenPaiNpc		= tbMenPaiNpc;

tbMenPaiNpc.tbFcts	= {
	{
		szDesc		= "Bổn tự ở trên đỉnh Thiếu Thất, là chính tông Phật pháp. Tâm nguyện của tăng chúng bổn tự chính là diệt trừ yêu ma, bảo vệ nhân tâm.\n"..
		            "<color=green>Nếu muốn quay về Tân Thủ Thôn, hãy đến gặp người Truyền Tống Môn Phái.<color>",
		tbTransPos	= {9,1731,3064},
		tbMiji		= {1, 2},
	}, {
		szDesc		= "Động Đình Hồ muôn trùng sóng cả, lắm cá nhiều tôm. Thiên Vương Bang ta từ khi sáng lập đến nay vẫn luôn trung thành với 8 chữ: diệt ác phò thiện, cứu khổ muôn dân.\n"..
		            "<color=green>Nếu muốn quay về Tân Thủ Thôn, hãy đến gặp người Truyền Tống Môn Phái.<color>",
		tbTransPos	= {22,1703,2987},
		tbMiji		= {3, 4},
	}, {
		szDesc		= "Đường vào đất Thục khó hơn lên trời. Đường Môn ta độc chiếm vùng Tây Nam, trong lòng lúc nào cũng muốn đứng đầu võ lâm Trung Nguyên, chẳng xem Đại Tống ra gì.\n"..
		            "<color=green>Nếu muốn quay về Tân Thủ Thôn, hãy đến gặp người Truyền Tống Môn Phái.<color>",
		tbTransPos	= {18,1652,3187},
		tbMiji		= {5, 6},
	}, {
		szDesc		= "30 năm trước triều đình ra lệnh truy sát, ép Ngũ Độc Giáo ta vào chốn rừng sâu. Nay chúng ta đã phục hồi nguyên khí, đang đợi thời cơ. Lòng người trên thiên hạ đều hiểm ác như nhau, thắng làm vua thua làm giặc cả thôi.\n"..
		            "<color=green>Nếu muốn quay về Tân Thủ Thôn, hãy đến gặp người Truyền Tống Môn Phái.<color>",
		tbTransPos	= {20,1459,2984},
		tbMiji		= {7, 8},
	}, {
		szDesc		= "Nga My phái từ thời chưởng môn Thanh Hiểu sư thái đến thời Vô Tưởng sư thái, luôn đứng đầu võ lâm, sánh với Thiếu Lâm, Võ Đang. Đệ tử bổn phái đều là nữ, không màng đến ân oán giang hồ, chỉ muốn giữ mình trong sạch.\n"..
		            "<color=green>Nếu muốn quay về Tân Thủ Thôn, hãy đến gặp người Truyền Tống Môn Phái.<color>",
		tbTransPos	= {16,1712,2908},
		tbMiji		= {9, 10},
	}, {
		szDesc		= "Vào thời Thúy Yên ta đang thịnh, muôn hoa đua thắm, đứng đầu võ lâm. Nay các tiền bối khi xưa đã có cõi đi về, đệ tử trẻ tuổi vẫn chưa trưởng thành, đang là lúc cần người tài như khát nước.\n"..
		            "<color=green>Nếu muốn quay về Tân Thủ Thôn, hãy đến gặp người Truyền Tống Môn Phái.<color>",
		tbTransPos	= {17,1355,2940},
		tbMiji		= {11, 12},
	}, {
		szDesc		= "Trong trận chiến Thái Thạch mấy mươi năm trước, lão bang chủ Hà Nhân của Cái Bang ta đã dẫn theo tứ đại trưởng lão cùng mấy ngàn đệ tử chống lại quân Kim, giúp Ngu Doãn Văn đại nhân giữ được Trường Giang. Nhưng việc này cũng khiến Cái Bang ta bị tổn thất nặng nề. Ta muốn tìm những chí sĩ yêu nước gia nhập Cái Bang, giúp sức chống quân Kim.\n"..
		            "<color=green>Nếu muốn quay về Tân Thủ Thôn, hãy đến gặp người Truyền Tống Môn Phái.<color>",
		tbTransPos	= {15,1706,3120},
		tbMiji		= {13, 14},
	}, {
		szDesc		= "Triều đình và Nam Tống sau hòa nghị Long Hưng đã có mấy mươi năm phục hồi nguyên khí, thật ra Thiên Nhẫn ta đâu muốn có chiến tranh? Có chiến tranh là có người chết. Nhưng bọn Thát Đát, Tây Hạ luôn có dã tâm, không thể không đề phòng được.\n"..
		            "<color=green>Nếu muốn quay về Tân Thủ Thôn, hãy đến gặp người Truyền Tống Môn Phái.<color>",
		tbTransPos	= {10,1797,3296},
		tbMiji		= {15, 16},
	}, {
		szDesc		= "Võ Đang ta là môn phái uy chấn thiên hạ. Từ sau khi Thiên Mục Đạo Trưởng mất tích, Trùng Dương chân nhân đảm nhiệm chức khách tọa chưởng môn cho đến nay. Võ Đang ta ở gần nơi giao tranh của hai nước Tống Kim, chân nhân đã chịu nhiều vất vả, mong rằng những nhân sỹ trẻ tuổi có thể ra tay giúp đỡ.\n"..
		            "<color=green>Nếu muốn quay về Tân Thủ Thôn, hãy đến gặp người Truyền Tống Môn Phái.<color>",
		tbTransPos	= {14,1408,2959},
		tbMiji		= {17, 18},
	}, {
		szDesc		= "Nếu không có nội loạn, Băng Tuyết Kiếm Khí của Côn Lôn Kiếm Tông hẳn đã tung hoành Trung Nguyên. May mắn thay Thu Thạch tiên sinh - đệ tử của Kiếm Hoàng Sở Khinh Thiên đã trở về từ Tây Vực, bắt tay với Thủ Tọa Hạ Viện Tạ Vũ Điền, đem lại luồng sinh khí cho Côn Lôn Phái.\n"..
		            "<color=green>Nếu muốn quay về Tân Thủ Thôn, hãy đến gặp người Truyền Tống Môn Phái.<color>",
		tbTransPos	= {12,1636,3034},
		tbMiji		= {19, 20},
	}, {
		szDesc		= "Minh Giáo ta từ sau nhà Đường không được triều đình công nhận, phải bí mật truyền giáo trong dân gian, cũng vì vậy mà bị hiểu lầm là tà giáo. Nay Đại Giáo Tông quyết định nhập thế, cứu bá tánh thoát khỏi cuộc sống đói khổ.\n"..
		            "<color=green>Nếu muốn quay về Tân Thủ Thôn, hãy đến gặp người Truyền Tống Môn Phái.<color>",
		tbTransPos	= {224,1747,3026},
		tbMiji		= {21, 22},
	}, {
		szDesc		= "Trăm năm nay Đoàn Thị chấn hưng trị quốc, vẫn không thành 1 nước lớn mạnh, nguyên nhân do hai Ô Man Tộc và Bạch Di không đồng lòng chung sức. Nay mong hào kiệt thiên hạ góp sức, giúp ta hoàn thành ước nguyện tổ tiên.\n"..
		            "<color=green>Nếu muốn quay về Tân Thủ Thôn, hãy đến gặp người Truyền Tống Môn Phái.<color>",
		tbTransPos	= {19,1691,3125},
		tbMiji		= {23, 24},
	},
};

tbMenPaiNpc.WEAPON_LIVE_TIME = 600;

tbMenPaiNpc.TBLV5_TRYSKILL_POS = {
	[1] = {30, 1722, 3876},
	[2] = {31, 1821, 3676},
	[3] = {32, 1750, 3655},
	[4] = {33, 1948, 3870},
	[5] = {34, 1831, 3775},
	[6] = {35, 1915, 3754},
	[7] = {36, 1692, 3695},
	[8] = {37, 1760, 3666},
	};

tbMenPaiNpc.tbFactionWeaponInfo = {
	[1] = {szName = "Đao Thiếu Lâm", tbGDPL = {2, 1, 1425, 10}};
	[2] = {szName = "Côn Thiếu Lâm", tbGDPL = {2, 1, 1426, 10}};
	[3] = {szName = "Thương Thiên Vương", tbGDPL = {2, 1, 1427, 10}};
	[4] = {szName = "Chùy Thiên Vương", tbGDPL = {2, 1, 1428, 10}};
	[5] = {szName = "Tụ Tiễn Đường Môn", tbGDPL = {2, 2, 162, 10}};
	[6] = {szName = "Hãm Tĩnh Đường Môn", tbGDPL = {2, 2, 161, 10}};
	[7] = {szName = "Đao Ngũ Độc", tbGDPL = {2, 1, 1429, 10}};
	[8] = {szName = "Chưởng Ngũ Độc", tbGDPL = {2, 1, 1430, 10}};
	[9] = {szName = "Phụ Trợ Nga My", tbGDPL = {2, 1, 1432, 10}};
	[10] = {szName = "Chưởng Nga My", tbGDPL = {2, 1, 1431, 10}};
	[11] = {szName = "Kiếm Thúy Yên", tbGDPL = {2, 1, 1433, 10}};
	[12] = {szName = "Đao Thúy Yên", tbGDPL = {2, 1, 1434, 10}};
	[13] = {szName = "Chưởng Cái", tbGDPL = {2, 1, 1435, 10}};
	[14] = {szName = "Côn Cái", tbGDPL = {2, 1, 1436, 10}};
	[15] = {szName = "Ma Nhẫn", tbGDPL = {2, 1, 1438, 10}};
	[16] = {szName = "Chiến Nhẫn", tbGDPL = {2, 1, 1437, 10}};
	[17] = {szName = "Kiếm Võ Đang", tbGDPL = {2, 1, 1440, 10}};
	[18] = {szName = "Khí Võ Đang", tbGDPL = {2, 1, 1439, 10}};
	[19] = {szName = "Đao Côn Lôn", tbGDPL = {2, 1, 1441, 10}};
	[20] = {szName = "Kiếm Côn Lôn", tbGDPL = {2, 1, 1442, 10}};
	[21] = {szName = "Kiếm Minh Giáo", tbGDPL = {2, 1, 1444, 10}};
	[22] = {szName = "Chùy Minh Giáo", tbGDPL = {2, 1, 1443, 10}};
	[23] = {szName = "Khí Đoàn Thị", tbGDPL = {2, 1, 1446, 10}};
	[24] = {szName = "Chỉ Đoàn Thị", tbGDPL = {2, 1, 1445, 10}};
	};

function tbMenPaiNpc:FactionDialog(fnCall)
	local tbOpt	= {};
	for nFactionId, tbFaction in ipairs(Player.tbFactions) do
		tbOpt[#tbOpt + 1]	= {tbFaction.szName, fnCall, self, nFactionId};
	end
	tbOpt[#tbOpt + 1]	= "Kết thúc đối thoại";
	Dialog:Say("Chọn môn phái muốn đối thoại?", tbOpt)
end;

function tbMenPaiNpc:DialogMaster(nFaction)
	if (me.nFaction and me.nFaction ~= 0) then
		local szFactionName = Player:GetFactionRouteName(me.nFaction)
		if (nFaction == me.nFaction) then
			local tbOpt	= {
							{"Ta muốn tiến hành tu luyện", self.OfferXiuLian, self},
							{"Ta muốn mua trang bị thi đấu môn phái", FactionBattle.tbFactionShop.OpenShop, FactionBattle.tbFactionShop, nFaction},
							{"Hoạt động thi đấu môn phái", FactionBattle.ChoiceFunc, FactionBattle, nFaction},
							{"Được phong Đại sư huynh (Đại sư tỷ)", FactionElect.ObtainWinnerTitle, FactionElect},
							
							{"Kết thúc đối thoại"}
						};
						
			Faction:InitChangeFaction(me);
			local nChangeGerneIndex = Faction:GetChangeGenreIndex(me);
			if nChangeGerneIndex == 0 then
				table.insert(tbOpt, #tbOpt - 1, {"Ta muốn vào Tẩy Tủy Đảo tẩy điểm", Xisuidao.OnEnterXisuidao_Xidian, Xisuidao, me});
				table.insert(tbOpt, #tbOpt - 1, {"Ta muốn vào Tẩy Tủy Đảo phụ tu các môn phái khác", Xisuidao.OnEnterXisuidao_Duoxiu, Xisuidao, me});
				table.insert(tbOpt, #tbOpt - 1, {"Ta muốn vào Tẩy Tủy Đảo đổi phụ tu môn phái", Xisuidao.OnEnterXisuidao_ModifyDuoxiu, Xisuidao, me});
			else
				table.insert(tbOpt, #tbOpt - 1, {"Ta muốn về Tẩy Tủy Đảo", Xisuidao.OnRecoverXisuidao, Xisuidao, me});
			end
			
			local szMsg	=	string.format("Chưởng môn: Ngươi đã là đệ tử %s, nếu muốn dùng bản đồ môn phái về Tân Thủ Thôn, hãy đối thoại với Truyền Tống Môn Phái.", szFactionName);
			
			if (20 <= me.nLevel) then
				local tbMijiDialog	= {"Nhận Mật tịch môn phái", self.OnAskMiji, self};
				table.insert(tbOpt, 1, tbMijiDialog);
			end
			if (60 <= me.nLevel) then
				local tbSignetDialog = {"Nhận Ngũ Hành Ấn", self.OnAskSignet, self, nFaction};
				table.insert(tbOpt, 1, tbSignetDialog);
			end

			Dialog:Say(szMsg, tbOpt);
			return;
		else
			Dialog:Say("Chưởng môn: Ngươi đã là đệ tử "..szFactionName..", không thể gia nhập bổn phái.");
			return;
		end
		return;
	end
	Dialog:Say("Chưởng môn: Ngươi có cốt cách dị thường, tư chất hơn người, mai đây ắt sẽ làm nên nghiệp lớn.\n"..
		         "<color=green>Nếu muốn quay về Tân Thủ Thôn, hãy đến gặp người Truyền Tống Môn Phái.<color>",
	{
		{"Sư phụ, xin nhận của đệ tử một lạy.", self.Join2, self, nFaction},
		{"Để ta suy nghĩ đã"},
	});
end;

function tbMenPaiNpc:OfferXiuLian()
	local nLevel	= me.nLevel;
	if (nLevel < 20) then
		Dialog:Say("Chưởng môn: Tu luyện? Vẫn chưa được đâu, hãy luyện thật tốt võ công cơ bản rồi quay lại. <color=red>(Phải đạt cấp 20)<color>");	
	else
		local nCount = me.GetItemCountInBags(18,1,16,1);
		if (nCount == 0) then
			local szMsg	=	"Chưởng môn: Mới đó ngươi đã nhập môn lâu như vậy rồi." ..
							"Đã đến lúc dạy ngươi cách phát huy tiềm năng vốn có để đạt cảnh giới tu luyện cao nhất, đây là 1 viên Tu Luyện Châu, " ..
				  			" tác dụng khơi dậy tiềm năng, "..
				  			"<color=green>Giúp ngươi đạt kinh nghiệm chiến đấu gấp 4 lần thông thường, đồng thời cũng mang đến vận may.<color>" ..
							" Tiềm năng cũng cần được tích lũy, hiện tại mỗi ngày ngươi nên tích lũy khoảng <color=red>1.5<color> giờ, lượng sức mà làm." ..
							"Bản thân hạt châu này không có giá trị, <color=green>nếu đánh mất cứ tới tìm ta lấy thêm.<color>"
			local tbOpt = 	{ { "Ta muốn nhận Tu Luyện Châu", self.GetXiuLianZhu, self }, { "Kết thúc đối thoại" } };
			Dialog:Say(szMsg, tbOpt);
		else
			Dialog:Say("<color=red>Ngươi đã có Tu Luyện Châu!<color>");
		end
	end
end

function tbMenPaiNpc:GetXiuLianZhu()

	local tbXiulianzhuItem = { Item.SCRIPTITEM, 1, 16, 1 }
	local tbBaseProp = KItem.GetItemBaseProp(unpack(tbXiulianzhuItem));
	if not tbBaseProp then
		return;
	end
	
	local tbItem =
	{
		nGenre		= tbXiulianzhuItem[1],
		nDetail		= tbXiulianzhuItem[2],
		nParticular	= tbXiulianzhuItem[3],
		nLevel		= tbXiulianzhuItem[4],
		nSeries		= (tbBaseProp.nSeries > 0) and tbBaseProp.nSeries or 0,
		bBind		= KItem.IsItemBindByBindType(tbBaseProp.nBindType),
		nCount 		= 1;
	};

	if (0 == me.CanAddItemIntoBag(tbItem)) then
		me.Msg("Túi đã đầy");
		return;
	end	

	tbXiulianzhuItem[5] = tbItem.nSeries;
	me.AddItem(unpack(tbXiulianzhuItem));
	me.Msg("Bạn nhận được 1 viên Tu Luyện Châu!");

end

function tbMenPaiNpc:OnAskMiji()
	local szMsg = "Ngươi muốn chọn mật tịch của nhánh môn phái nào?";
	local tbOpt = {};
	for i=1, 2 do
		local szRouteName = Player:GetFactionRouteName(me.nFaction, i);
		local tbMiji	= {szRouteName, self.OnAskForMoney, self, me.nFaction, i};
		table.insert(tbOpt, tbMiji);
	end
	Dialog:Say(szMsg, tbOpt);
end

function tbMenPaiNpc:OnAskSignet(nFaction, bConfirm)
	if me.CountFreeBagCell() < 1 then
		Dialog:Say("Túi bạn đã đầy")
		return 0;
	end
	if not bConfirm then
		Dialog:Say("Ngươi xác định nhận Ngũ Hành Ấn?",
			{
				{"Đúng, ta muốn nhận", self.OnAskSignet, self, nFaction, 1},
				{"Có rồi"},
			})
		return 0;
	end
	
	me.AddItem(1,16,nFaction,1,0);
end

function tbMenPaiNpc:OnAskForMoney(nFaction, nRouteId)
	local szMsg	= "Tất cả đệ tử môn phái khi đạt <color=red>cấp 20<color>, đều được nhận Bồ câu đưa thư của ta, được 1 quyển Mật tịch miễn phí. <color=green>(Nhấn phím I mở giao diện Bồ câu đưa thư)<color>\n"..
	              "Nhận lại mật tịch phải tốn <color=yellow>500<color> bạc, ngươi có muốn nhận?" ;
	local tbOpt	= 	{
						{"Đồng ý nhận.", self.OnOfferMiji, self, nFaction, nRouteId},
						{"Ta phải suy nghĩ lại đã"},
					};
	Dialog:Say(szMsg, tbOpt);
end

function tbMenPaiNpc:OnOfferMiji(nFaction, nRouteId)
	local nMyMoney	= me.nCashMoney; --GetCash();
	
	if (nMyMoney < 500) then
		Dialog:Say("Không đủ bạc, có đủ rồi hãy quay lại.");
		return 0;
	end

	if (0 == nFaction) then
		print("Chưa gia nhập môn phái? Thật không đó?");
		return 0;
	end

	if (0 == nRouteId) then
		Dialog:Say("Chưa chọn nhánh, không thể nhận Mật tịch môn phái!");
		return 0;
	end
	self:GetMiji(nFaction, nRouteId);	
end

function tbMenPaiNpc:GetMiji(nFaction, nRouteId)

	local nMijiId	=	self.tbFcts[nFaction].tbMiji[nRouteId];
	local nCount 	=	me.GetItemCountInBags(1, 14, nMijiId, 1, -1);
	if (0 < nCount) then
		Dialog:Say("Đã có Mật tịch");
		return 0;
	end
	local tbMijiItem = { Item.EQUIP_GENERAL, 14, nMijiId, 1 };
	local tbBaseProp = KItem.GetItemBaseProp(unpack(tbMijiItem));
	if not tbBaseProp then
		return 0;
	end

	local tbItem =
	{
		nGenre		= tbMijiItem[1],
		nDetail		= tbMijiItem[2],
		nParticular	= tbMijiItem[3],
		nLevel		= tbMijiItem[4],
		nSeries		= (tbBaseProp.nSeries > 0) and tbBaseProp.nSeries or 0,
		bBind		= KItem.IsItemBindByBindType(tbBaseProp.nBindType),
		nCount 		= 1;
	};

	if (0 == me.CanAddItemIntoBag(tbItem)) then
		me.Msg("Túi đã đầy");
		return;
	end

	if (0 >= me.CostMoney(500, Player.emKPAY_MIJI)) then
		print("[MiJi] tbMenPaiNpc:GetMiji(nFaction, nRouteId) the money is wrong!");
		return 0;
	end

	tbMijiItem[5] = tbItem.nSeries;
	me.AddItem(unpack(tbMijiItem));
	Dialog:Say("Mật tịch đã giao cho ngươi, đây là bí mật môn phái, tuyệt đối không được tiết lộ.");
	return 1;

end

function tbMenPaiNpc:Join2(nFaction)
	local nSex = me.nSex
	local nSexLimit	= Player.tbFactions[nFaction].nSexLimit;
	if (nSexLimit >= 0 and nSexLimit ~= nSex) then
		Dialog:Say("Chưởng môn: Bổn phái không nhận đệ tử "..Player.SEX[nSex]..", thí chủ hãy chọn môn phái khác.");
		return 0;
	end
	if (me.nLevel < 10) then
		Dialog:Say("Chưởng môn: Cấp độ của ngươi không đủ, đạt đến cấp <color=red>10<color> hãy quay lại!");
		return 0;
	end;
	local nCurFaction = me.nFaction
	local szFactionName
	if nCurFaction ~= 0 then
		szFactionName = Player:GetFactionRouteName(nCurFaction);
		Dialog:Say("Chưởng môn: Ngươi đã là đệ tử "..szFactionName..", không thể gia nhập bổn phái");
		return 0;
	end
	me.LeaveTeam();
	me.JoinFaction(nFaction);
	self:AddAngerMagic(me);
	szFactionName = Player:GetFactionRouteName(nFaction);
	
	Player:ReAssignPotential();
	
	if (me.GetCamp() == 6) then
		me.AddFightSkill(91, 60);	-- 银丝飞蛛
		me.AddFightSkill(163, 60);	-- 梯云纵
		me.AddFightSkill(1417, 1);	-- 1级移形换影
	end
	
	local nInEducation = me.GetTask(1021, 7);
	local szMsg = "";
	if (nInEducation == 1) then
		szMsg = "Tuyệt học môn phái tinh thâm uyên bác, vẫn không ngoài nguyên tắc khổ luyện chuyên cần. Ngươi đã gia nhập phái ta thì phải dốc sức luyện tập, mai này hành hiệp trượng nghĩa, cứu giúp bá tánh. Duyên sư đồ của hai ta còn dài, sau này ắt sẽ còn gặp lại, ngươi cứ yên tâm về thôn bẩm báo với Thu Lâm.";
	else
		szMsg = "Đã là đệ tử phái ta phải ý thức chăm chỉ học hành, mai này thành đạt mới không phụ lòng dạy dỗ của sư môn.";
	end
	Dialog:Say(szMsg.."\n\n"..
		"Nhấn nút giao diện kỹ năng hoặc phím tắt F3 sẽ thấy hai nhánh luyện công môn phái.\n\n"..
		"<color=yellow>Võ công bổn môn chia 2 nhánh, mỗi nhánh dùng vũ khí tương ứng. Chỉ được tu luyện theo nhánh đã chọn cho đến cấp 60, sau đó có thể truyền tống đến Tẩy Tủy Đảo để đổi hướng tu luyện.\n\n"..
		"Đạt cấp 20 đến gặp ta nhận Tu Luyện Châu, giúp nâng cao hiệu suất luyện công.<color>",
		{{"Đệ tử xin tuân lệnh"}});
	me.Msg("Bạn đã thành công gia nhập "..szFactionName..", và học được kỹ năng "..szFactionName..", mở giao diện kỹ năng (F3) để cộng điểm.")
	me.Msg("Nhận được kỹ năng nộ khí mới");
end

function tbMenPaiNpc:AddAngerMagic(pPlayer)
	local tbAngerSkill = FightSkill.tbAngerSkill;
	local nSeries = pPlayer.nSeries;
	if (me.IsHaveSkill(281) == 1) then
		pPlayer.DelFightSkill(281);
	end
	pPlayer.AddFightSkill(tbAngerSkill[nSeries],1);
end

function tbMenPaiNpc:CanTrySkill()
	if (me.GetTask(1022, 225) ~= 1) then
		return 0;
	end
	return 1;
end

function tbMenPaiNpc:DialogJieYinRen(nFaction)
	local szMsg = "<color=yellow>"..him.szName.."<color>: "..self.tbFcts[nFaction].szDesc;
	local tbOpt = {};
	table.insert(tbOpt, {"Đưa ta đi "..Player:GetFactionRouteName(nFaction), self.Transfer, self, nFaction});
	
	local nIndex1 = 2 * nFaction - 1;
	local nIndex2 = 2 * nFaction;
	
	if (self:CanTrySkill() == 1 and self.tbFactionWeaponInfo[nIndex1] and self.tbFactionWeaponInfo[nIndex2]) then
		local szMsg1 = string.format("Thử kỹ năng <color=yellow>%s<color>", self.tbFactionWeaponInfo[nIndex1].szName);
		table.insert(tbOpt, {szMsg1, self.GetItem4TrySkillDlg, self, nIndex1, nFaction, self.tbFactionWeaponInfo[nIndex1].szName});

		local szMsg2 = string.format("Thử kỹ năng <color=yellow>%s<color>", self.tbFactionWeaponInfo[nIndex2].szName);
		table.insert(tbOpt, {szMsg2, self.GetItem4TrySkillDlg, self, nIndex2, nFaction, self.tbFactionWeaponInfo[nIndex2].szName});
		
		table.insert(tbOpt, {"Ta không muốn thử kỹ năng môn phái", self.LeaveWithoutTrySkill, self, nFaction});
	else
		table.insert(tbOpt, {"Rời khỏi"});
	end
	
	Dialog:Say(szMsg, tbOpt);
end;

function tbMenPaiNpc:LeaveWithoutTrySkill(nFaction)
	me.SetTask(Player.TSKGROUP_NEWPLAYER_GUIDE, Player.TSKID_NEWPLAYER_FACTION, nFaction);
end

function tbMenPaiNpc:GetItem4TrySkillDlg(nIndex, nFaction, szSkillName)
	local szMsg = string.format("Xác định muốn thử kỹ năng <color=yellow>%s<color>? (Lưu ý:\n<color=yellow>1. Vũ khí dùng khi thử kỹ năng môn phái chỉ có hiệu lực 10 phút.<color>\n2. Nếu đã thử qua kỹ năng khác, khi thử kỹ năng này, kỹ năng lần trước sẽ mất hiệu lực.)",
								szSkillName);
	local tbOpt = {
		{"Được, ta muốn thử", self.GetItem4TrySkill, self, nIndex, nFaction},
		{"Để ta suy nghĩ lại đã!"},
		};
	Dialog:Say(szMsg, tbOpt);
end

function tbMenPaiNpc:GetItem4TrySkill(nIndex, nFaction)
	if (not nIndex or not self.tbFactionWeaponInfo[nIndex]) then
		return;
	end
	
	me.SetTask(Player.TSKGROUP_NEWPLAYER_GUIDE, Player.TSKID_NEWPLAYER_FACTION, nFaction);
	
	self:DelTrySkillWeapon();
	
	if (me.CountFreeBagCell() < 1) then
		me.Msg("Túi đã đầy, hãy dọn trống 1 ô rồi quay lại.");
		return;
	end
	
	local tbGDPL = self.tbFactionWeaponInfo[nIndex].tbGDPL;
	Lib:ShowTB(tbGDPL);
	local pItem = me.AddItem(unpack(tbGDPL));
	if (pItem) then
		me.SetItemTimeout(pItem, os.date("%Y/%m/%d/%H/%M/%S", GetTime() + self.WEAPON_LIVE_TIME));
		if (me.CanUseItem(pItem) == 1) then
			me.AutoEquip(pItem);	-- 自动装备上
			self:TrySkillDlg();
		end
	end
end

function tbMenPaiNpc:TrySkillDlg()
	local szMsg = string.format("Muốn truyền tống đến bản đồ cấp 5 gần nhất để thử kỹ năng môn phái?\nLưu ý: Kỹ năng có thể thử đã xuất hiện trong giao diện kỹ năng F3, có thể đặt các kỹ năng này vào thanh phím tắt để thử.");
	local tbOpt = {
		{"Được, hãy đưa ta đến đó.", self.Send2Lv5Map, self},
		{"Lát sẽ quay lại"},
		};
	Dialog:Say(szMsg, tbOpt);
end

function tbMenPaiNpc:Send2Lv5Map()
	local nMapId = me.nMapId;
	local tbPos = self.TBLV5_TRYSKILL_POS[nMapId];
	if (tbPos) then
		me.NewWorld(unpack(tbPos));
	end
end

function tbMenPaiNpc:DelTrySkillWeapon()
	local tbAllRoom = {
			Item.ROOM_EQUIP,
			Item.ROOM_EQUIPEX,
			Item.ROOM_MAINBAG,
			Item.ROOM_EXTBAG1,
			Item.ROOM_EXTBAG2,
			Item.ROOM_EXTBAG3,
			Item.ROOM_REPOSITORY,
			Item.ROOM_EXTBAGBAR,
			Item.ROOM_MAIL,
			Item.ROOM_TRADE,
			Item.ROOM_TRADECLIENT,
			Item.ROOM_RECYCLE,
		}
		
	local tbCurGDPL = {};
	for _, tbInfo in pairs(self.tbFactionWeaponInfo) do
		local szGDPL = string.format("%s-%s-%s-%s", unpack(tbInfo.tbGDPL));
		tbCurGDPL[szGDPL] = {};
	end
	
	for _, nRoom in pairs(tbAllRoom) do
		local tbIdx = me.FindAllItem(nRoom);
		if (tbIdx) then
			for i = 1, #tbIdx do
				local pItem = KItem.GetItemObj(tbIdx[i]);
				if (pItem) then
					local szGDPL = string.format("%s-%s-%s-%s", pItem.nGenre, pItem.nDetail, pItem.nParticular, pItem.nLevel);
					if (tbCurGDPL[szGDPL]) then
						pItem.Delete(me);
					end
				end
			end
		end
	end		
end

function tbMenPaiNpc:Transfer(nFaction)
	if (me.nLevel < 10) then
		Dialog:Say("Công lực của bạn còn yếu, tới <color=yellow>cấp 10<color> mới truyền tống được.");
		return 0;
	end;
	me.NewWorld(unpack(self.tbFcts[nFaction].tbTransPos));
end

function tbMenPaiNpc:Intro(nFaction)
		Dialog:Say(self.tbFcts[nFaction].szDesc, {
			{"Trở về", self.DialogJieYinRen, self, nFaction},
			{"Rời khỏi"},
			});
end

function tbMenPaiNpc:LearnSkill()
	if (me.nLevel < 10) then
		Dialog:Say("Bạn đã học được kỹ năng.");
		return 0;
	end;
end;

