Require("\\script\\item\\class\\equip.lua");

------------------------------------------------------------------------------------------
-- initialize

local tbSoulSignet = Item:NewClass("soulsignet", "equip");
if not tbSoulSignet then
	tbSoulSignet = Item:GetClass("soulsignet");
end

------------------------------------------------------------------------------------------
-- public

function tbSoulSignet:GetTip(nState)		-- 获取印章Tip
	local szTip = "";
	szTip = szTip..self:Tip_ReqAttrib();
	szTip = szTip..self:Tip_Durability();
	szTip = szTip..self:Tip_Level();
	szTip = szTip..self:Tip_Series(nState);
	szTip = szTip..self:Tip_BaseAttrib(nState);
	return szTip;
end

function tbSoulSignet:Tip_BaseAttrib(nState)	-- 获得Tip字符串：基础属性

	local szTip = "\n\n<color=blue>Cấp sao thuộc tính và tư chất<color>\n\n";
	local tbAttrib = it.GetBaseAttrib();	-- 获得道具基础属性
	
	for i, tbMA in ipairs(tbAttrib) do	
		local szDesc = self:GetMagicAttribDesc(tbMA.szName, tbMA.tbValue);
		local nLevel, nExp, nUpgradeExp = Item:CalcSoulUpgrade(it, i, 0);
		if (szDesc ~= "") and (nLevel >= 0) then		
			local nStarLevel = math.floor((nLevel / Item.tbMAX_SOULSIGNET_LEVEL[it.nLevel][i])*18);
			local szStar = self:GetAttribStar(nStarLevel, 1);
			local szAttribTipName = self:GetAttribTipName(tbMA.szName);
			local szAttribTipDesc = self:GetAttribTipDesc(tbMA.szName);		
			local bInvalid = it.IsInvalid();
			if nLevel >= Item.tbMAX_SOULSIGNET_LEVEL[it.nLevel][i] then 
				nExp = 0;
				nUpgradeExp = 0;
			end
			if nLevel < Item.tbMAX_SOULSIGNET_LEVEL[it.nLevel][i] then
				if nLevel < 25 then
					szTip = szTip..string.format("<color=green>%s: %d→%d [%d/%d]\n<color=white>%s<color><color>\n", szAttribTipName,  nLevel, nLevel+1, nExp, nUpgradeExp, szAttribTipDesc);
				else
					szTip = szTip..string.format("<color=green>%s: %d→%d [%d/%d]\n<color=white>%s<color><color>\n\n", szAttribTipName,  nLevel, nLevel+1, nExp, nUpgradeExp, szAttribTipDesc);
				end
			else
				szTip = szTip..string.format("<color=green>%s: %d [Đạt tối đa]\n<color=white>%s<color><color>\n\n", szAttribTipName, nLevel, szAttribTipDesc);
			end
			szTip = szTip..string.format("   %s\n", szStar);
		end
	end
		
	if szTip ~= "" then
		return	"<color=green>"..szTip.."<color>";
	end
	return szTip;
end

function tbSoulSignet:GetAttribStar(nPotenLevel, nType)
	local tbSetting = Partner.tbStarLevel;
	local szFillStar = "";
	local szEmptyStar = "";
	if nType == 1 and tbSetting and tbSetting[nPotenLevel] then
		szFillStar = string.format("<pic=%s>", tbSetting[nPotenLevel].nFillStar - 1);
		szEmptyStar = string.format("<pic=%s>", tbSetting[nPotenLevel].nEmptyStar - 1);
	else
		szFillStar = "★";
		szEmptyStar = "☆";
	end
	local szStar = "";
	
	for i = 1, math.floor(nPotenLevel / 2) do
		szStar = szStar..szFillStar;
		if i % 3 == 0 then
			szStar = szStar.." ";
		end
	end
	if (nPotenLevel % 2 ~= 0) then
		szStar = szStar..szEmptyStar;
	end
	
	return szStar;
end

function tbSoulSignet:CalcValueInfo()
	local nValue = it.nOrgValue;
	local tbSetting = Item:GetExternSetting("soulsignet", it.nVersion);
	if tbSetting then
		for i = 1, Item.SOULSIGNET_ATTRIB_NUM do
			local nLevel = it.GetGenInfo(2 * i - 1);
			if tbSetting["m_LevelValue"..i][nLevel] then
				nValue = nValue + tbSetting["m_LevelValue"..i][nLevel];
			end
		end
	end
	
	local nStarLevel, szNameColor, szTransIcon = Item:CalcStarLevelInfo(it.nVersion, it.nDetail, it.nLevel, nValue);
	
	return	nValue, nStarLevel, szNameColor, szTransIcon;
end

function tbSoulSignet:GetAttribTipName(varAttrib)
	local nId = 0;
	if type(varAttrib) == "number" then
		nId = varAttrib;
	elseif type(varAttrib) == "string" then
		nId = Item.tbZhenYuanSetting.tbAttribNameToId[varAttrib];
	end
	
	if not nId or nId == 0 then
		return "";
	end
	
	return Item.tbZhenYuanSetting.tbAttribSetting[nId].szTipText;
end

function tbSoulSignet:GetAttribTipDesc(varAttrib)
	local nId = 0;
	if type(varAttrib) == "number" then
		nId = varAttrib;
	elseif type(varAttrib) == "string" then
		nId = Item.tbZhenYuanSetting.tbAttribNameToId[varAttrib];
	end
	
	if not nId or nId == 0 then
		return "";
	end
	
	return Item.tbZhenYuanSetting.tbAttribSetting[nId].szTipDesc;
end
